#ifndef LLF_DES_H
#define LLF_DES_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"
#include "CE2_DES.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Fri Mar 02 14:44:38 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level function
* to operate the DES machine in one integrated operation,
* which worked with LibTomCrypt.
* 
* \version LLF_DES.h#1:csrc:1
* \author Pavel Sasunkevich
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_DES
*
* Inputs:
* @param IV_ptr [in\out] - This parameter is the buffer of the IV;
* @param Key_ptr [in] - A pointer to the user's key buffer;
* @param NumOfKeys [in] - The number of keys used: 1, 2, or 3 (defined in the enum);
* @param EncryptDecryptFlag [in] - A flag that determines if the DES should perform;
* @param OperationMode [in] - The operation mode: ECB or CBC;
* @param DataIn_ptr [in] - The pointer to the buffer of the input data to the DES;
* @param DataInSize [in] - The size of the input data.
* @param DataOut_ptr [in\out] - The pointer to the buffer of the output data from the DES;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*   This function is used to operate the DES machine in one integrated
* operation: an Encrypt or a Decrypt operation, using operation
* mode: ECB or CBC.
*
* \b
* Algorithm:
*  -# Initialize DES machine;
*  -# Initialize operation mode: ECB or CBC;
*  -# Perform operation: an Encrypt operation or a Decrypt operation.
***************************************************************/
CE2Error_t LLF_DES  ( CE2_DES_Iv_t            IV_ptr,			/* in, out */
                      CE2_DES_Key_t           *Key_ptr,			/* in */
                      CE2_DES_NumOfKeys_t     NumOfKeys,		/* in */
                      CE2_DES_EncryptMode_t   EncryptDecryptFlag,/* in */
                      CE2_DES_OperationMode_t OperationMode,	/* in */
                      DxUint8_t              *DataIn_ptr,		/* in */
                      DxUint32_t              DataInSize,		/* in */
                      DxUint8_t              *DataOut_ptr );	/* in, out */

#ifdef __cplusplus
}
#endif

#endif /* LLF_DES_H */
